/* Time-stamp: <2004-05-21 11:43:48 poser> */
/*
 * Reverse a speech file, sample by sample.
 *
 * modified 6/23/86 by Ken Cooper - cut space required in half.
 * modified 10/15/89 by Bill Poser to run on Bobcats (removed header stuff)
 * modified 2004/05/21 to use libsndfile.
 *
 * Copyright (C) 1985-2004 William J. Poser (billposer@alum.mit.edu)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * or go to the web page:  http://www.gnu.org/licenses/gpl.txt.
 */

#include <stdlib.h>
#include <stdio.h>
#include <sndfile.h>

static char pgname[] = "backtalk";

main(int ac, char **av)
{

  register long i;		/* Loop index */
  register long j;		/* Loop index */
  register short *array;	/* The speech */
  register short temp;		/* Temp variable for swapping */

  SNDFILE *infd;		/* Input file descriptor */
  SNDFILE *outfd;		/* Output file descriptor */
  long SamplesInFile;		/* Samples in input file */
  long SamplesRead;		/* Bytes read */
  long SamplesWritten;		/* Bytes written */
  long BytesNeeded;
  struct SF_INFO sinfo;
   
  /* Process command line arguments */

  if(ac < 3){
    fprintf(stderr,"Copyright 1985-2004 William J. Poser.\n");
    fprintf(stderr,"Released under the terms of the GNU General Public License.\n");
    fprintf(stderr,"\nReverse a speech file sample by sample.\n");
    fprintf(stderr,"Usage: %s <input file> <output file>\n\n",pgname);
    exit(1);
  }

  /* Open input */

  sinfo.format = 0;
  infd = sf_open(av[1],SFM_READ,&sinfo);
  if(infd == NULL){
    fprintf(stderr,"%s: could not open file %s for read.\n",pgname,av[1]);
    exit(2);
  }
  if(sinfo.channels != 1){
    fprintf(stderr,
	    "%s: audio file %s has %d channels. Only mono data can be processed.\n",
	    pgname,av[1],sinfo.channels);
    exit(3);
  }
  SamplesInFile = sinfo.frames;

  /* Allocate storage */
 
  BytesNeeded =  SamplesInFile * sizeof(short);
  array = (short *) malloc((size_t) BytesNeeded);
  if (array == (short *) 0){
    fprintf(stderr,"\nCannot allocate %u bytes storage for data.\n",BytesNeeded);
    exit(1);
  }

   
  /* Open output file */
   
  outfd = sf_open(av[2],SFM_WRITE,&sinfo);
  if(outfd == NULL){
    fprintf(stderr,"%s: could not open file %s for write.\n",pgname,av[2]);
    exit(2);
  }

  /* Read audio into array */

  SamplesRead = sf_read_short(infd,array, SamplesInFile);
  if(SamplesRead != SamplesInFile){
    fprintf(stderr,"%s: error reading file %s\n",pgname,av[1]);
    exit(1);
  }
  sf_close(infd);


  /* Reverse array */

  for(i = 0L, j = SamplesInFile - 1L; i < j; i++, j--) {
    temp = array[i];
    array[i] = array[j];
    array[j] = temp;
  }

   /* Write out array */

  SamplesWritten = sf_write_short(outfd,array,SamplesRead);
  if(SamplesWritten != SamplesRead){
    fprintf(stderr,"%s: error writing output file %s.\n",
	    pgname,av[2]);
    unlink(av[2]);
    exit(4);
  }

  sf_close(outfd);
  exit(0);
}
